/*(*[SettingsPanel]
Control="Label";Caption="The content is generated by javascript";Params="[FULLWIDTH]"
Control="CheckBox";Name="ckbGenSqlMap";Caption="SQLMAP: ";Items="Generate SQLMAP";Value=""
[/SettingsPanel]*)*/

function extStr(str, len)
{
  str = str.trim();
  if (str.length <= len)
    for(var i=str.length; i<=len; i++)
      str = str + ' ';
  return str;
}

function DEF_CTMETAFIELD_DATATYPE_NAMES_JAVA(cfType)
{
  if(cfType.indexOf("cfdt")==0){
	  var res= cfType.substr(4);
	  if(res=="Integer")
		 return "int";
	  if(res=="Float")
		 return "double";
	  if(res=="Bool")
		 return "boolean";
	  if(res=="Enum")
		 return "int";
	  if(res=="Blob")
		 return "Object";
	  if(res=="Event")
		 return "EventClass";
	  if(res=="Other")
		 return "class";
	  return res;
  }
  else
	  return cfType;

}


function getCamelCaseOfUnderlineName(aName)
{
  if (aName.toUpperCase()==aName)
    return aName;

  var res=aName;
  while (res.indexOf('_')>=0)
  {
    var s = res;
    var po = s.indexOf('_');
	  var s1=s.substring(0,po);
	  var s2=s.substr(po+1);
    if (s2.length>0)
		s2=s2.charAt(0).toUpperCase()+s2.substr(1);
    res=s1+s2;
  }
  return res;
}


function getProtectName(aName)
{
  var res = getCamelCaseOfUnderlineName(aName);
  if(res!="")
    res=res.charAt(0).toLowerCase()+res.substr(1);
  return res;
}

function getPublicName(aName)
{
  var res = getCamelCaseOfUnderlineName(aName);
  if(res!="")
    res=res.charAt(0).toUpperCase()+res.substr(1);
  return res;
}


function getDesName(p, n)
{
  if (!p)
    return n;
  else
    return p;
}

function gFieldName(f)
{
  return getDesName(f.name, f.displayName);
}

function gFieldType(f)
{
  if (f.dataType == 'cfdtOther')
    return f.dataTypeName;
  else if (f.dataType == 'cfdtEnum')
    return getPublicName(gFieldName(f));
  else
    return DEF_CTMETAFIELD_DATATYPE_NAMES_JAVA(f.dataType);
}

function replaceAllCRs(s, ns){
    var t=s;
    t = t.replace(/\r\n/g, "\n");
    t = t.replace(/\r/g, "\n");
    t = t.replace(/\n/g, "\n"+ns);
	return t;
}

function addFieldInfo(f)
{
  var s = getDesName(f.name, f.displayName);
  var t = f.getFieldComments();
  if (t)
  {
    t = replaceAllCRs(t, " * ");
  }

  var ft="";
  var t2="";
  if (f.dataType == 'cfdtFunction')
  {
    ft = f.dataTypeName;
    if (ft == '')
      ft = 'void';
    if (t)
      t2 = '/**\r\n * ' + t + '\r\n */\r\n';
    else
      t2 = '';
    s = t2+ 'public ' + ft + ' ' + getPublicName(s) + '()\r\n'
      + '{\r\n'
      + '}';
  }
  else
  {
    if (f.dataType == 'cfdtOther')
      ft = f.dataTypeName
    else if (f.dataType == 'cfdtEnum')
      ft = gFieldType(f)
    else
      ft = DEF_CTMETAFIELD_DATATYPE_NAMES_JAVA(f.dataType);
    if (t)
    {
      t1 = '/**\r\n * Get ' + t + '\r\n */\r\n';
      t2 = '/**\r\n * Set ' + t + '\r\n */\r\n';
    }
    else
    {
      t1 = '';
      t2 = '';
    }
    s = t1+'public ' + ft + ' get' + getPublicName(s) + '()\r\n'
      + '{\r\n'
      + '  return ' + getProtectName(s) + ';\r\n'
      + '}\r\n'
      + t2+'public void set' + getPublicName(s) + '(' + ft + ' value)\r\n'
      + '{\r\n'
      + '  this.' + getProtectName(s) + ' = value;\r\n'
      + '}';
  }

  s = replaceAllCRs(s, "  ");
  curOut.add('  ' + s);
}

var i,f;
var tb=curTable;
var s = tb.getTableComments();
curOut.add('/**');
curOut.add(' * ' + tb.name);
if (s)
  curOut.add(' * ' + replaceAllCRs(s, ' * '));
curOut.add(' * @author User(EMAIL) ' + _dateTimeToStr(_now()));
curOut.add(' * @version 1.0');
curOut.add(' * Generated by javascript');
curOut.add('');
curOut.add(tb.describe);
curOut.add('');

if(curSettingsPanel)
  s=curSettingsPanel.getItemValue("ckbGenSqlMap");
else
  s="";
if(s=="True"){
	curOut.add('SQLMAP:');
	curOut.add('<resultMap id="resMap_' + tb.name + '"');
	curOut.add('	class="' + tb.name + '.' + tb.name + '">');
	for (i=0; i< tb.metaFields.count;i++)
	{
	  f = tb.metaFields.getItem(i);
	  curOut.add('	<result property="' + getProtectName(gFieldName(f)) + '" column="' + gFieldName(f).toUpperCase() + '" />');
	}
	curOut.add('</resultMap>');
	curOut.add('<select id="sel_' + tb.name + '" resultMap="resMap_' + tb.name + '"><![CDATA[');
	curOut.add('  select t.* from ' + tb.name + ' t');
	curOut.add(']]></select>');
	curOut.add('');
}
curOut.add('*/');
curOut.add('');

curOut.add('package ' + tb.name + ';');
curOut.add('');
curOut.add('import java.sql.Date;');
curOut.add('');

s = tb.getTableComments();
if (s)
{
  curOut.add('/** \r\n * ' + replaceAllCRs(s, ' * ') + '\r\n */');
}

var L = 0;
for (i=0;i<tb.metaFields.count;i++)
{
  f = tb.metaFields.getItem(i);
  s = getDesName(f.name, f.displayName);
  if (L < s.length)
	L = s.length;
}

var clsName = getPublicName(tb.name);

curOut.add('public class ' + clsName);
curOut.add('{');

for (i=0;i<tb.metaFields.count;i++)
{
  f = tb.metaFields.getItem(i);
  if(f.dataType == 'cfdtEnum')
  {
	curOut.add('  public enum ' + getPublicName(gFieldName(f)) + ' {');
	curOut.add('     ' + getPublicName(gFieldName(f)) + '_Unknow = 0,');
	curOut.add('     ' + getPublicName(gFieldName(f)) + '_Value1 = 1,');
	curOut.add('     ' + getPublicName(gFieldName(f)) + '_Value2 = 2');
	curOut.add('  }');
	curOut.add('');
  }
}

for (i=0;i<tb.metaFields.count;i++)
{
  f = tb.metaFields.getItem(i);
  if(f.dataType != 'cfdtFunction')
  {
	s = f.getFieldComments();
	if (s)
	{
      s = replaceAllCRs(s, "   * ");
	  s = '  /**\r\n   * ' + s + '\r\n   */';
	  curOut.add(s);
	}
	curOut.add('  protected ' + gFieldType(f) + ' ' + getProtectName(gFieldName(f)) + ';');
  }
}
curOut.add('');

curOut.add('  public ' + clsName + '()');
curOut.add('  {');
curOut.add('  }');

curOut.add('');
for (i=0;i<tb.metaFields.count;i++)
{
  f = tb.metaFields.getItem(i);
  addFieldInfo(f);
}

curOut.add('');
curOut.add('  public void reset()');
curOut.add('  {');
for (i=0;i<tb.metaFields.count;i++)
{
  f = tb.metaFields.getItem(i);
  s = getProtectName(gFieldName(f));
  v = '';
  if(f.dataType == 'cfdtInteger' || f.dataType == 'cfdtFloat')
	  curOut.add('    ' + extStr(v + s, L) + ' = 0;');
  else if(f.dataType == 'cfdtString')
	  curOut.add('    ' + extStr(v + s, L) + ' = null;');
  else if(f.dataType == 'cfdtDate')
	  curOut.add('    ' + extStr(v + s, L) + ' = null;');
  else if(f.dataType == 'cfdtEnum')
	  curOut.add('    ' + extStr(v + s, L) + ' = ' + getPublicName(gFieldName(f)) + '_Unknown;');
  else if(f.dataType == 'cfdtBool')
	  curOut.add('    ' + extStr(v + s, L) + ' = false;');
  else if(f.dataType == 'cfdtList')
	  curOut.add('    ' + extStr(v + s, L) + '.Clear();');
  else if(f.dataType == 'cfdtEvent')
	  curOut.add('    ' + extStr(v + s, L) + ' = null;');
  else if(f.dataType == 'cfdtFunction'){}
  else
	  curOut.add('    ' + extStr(s, L) + ' .reset();');
}
curOut.add('  }');
curOut.add('');


curOut.add('  public void assignFrom(' + clsName + ' AObj)');
curOut.add('  {');
curOut.add('    if(AObj==null)');
curOut.add('    {');
curOut.add('      Reset();');
curOut.add('      return;');
curOut.add('    }');
for (i=0;i<tb.metaFields.count;i++)
{
  f = tb.metaFields.getItem(i);
  s = getProtectName(gFieldName(f));
  v = ''; //RemRootCtField(f.Name);
  if( f.dataType == 'cfdtString'|| f.dataType == 'cfdtInteger' ||f.dataType == 'cfdtFloat'|| f.dataType == 'cfdtDate'|| f.dataType == 'cfdtBool'|| f.dataType == 'cfdtEnum')
	  curOut.add('    ' + extStr(v + s, L) + ' = AObj.' + s + ';');
  else if( f.dataType == 'cfdtFunction'|| f.dataType == 'cfdtEvent'){}
  else
  	curOut.add('    ' + extStr(s, L) + ' .  assignFrom(AObj.' + s + ');');
}
curOut.add('  }');
curOut.add('');


curOut.add('}');
curOut.add('');
