<%
var parentPkgName=GetGParamValue('EZGEN_ROOT_PKGNAME'); //ϼ
if(!parentPkgName)parentPkgName='com.ezdml.codegen.ezdmlcodegendemo';

var tb=curTable; //ǰ
var ClsName=AutoCapProc(tb.name,'ClassName'); //շĸд
var tbName=AutoCapProc(tb.name,'FieldName'); //ֶշĸСд
var dispName=tb.UIDisplayName; //߼ʾ
var pkField="id"; //
var idTp="Long";
var idValExp="id";
var idV1="1L";
var idV2="2L";
if(tb.getPrimaryKeyField()){
  pkField=AutoCapProc(tb.getPrimaryKeyField().name,'FieldName');
  if(tb.getPrimaryKeyField().dataType=='cfdtString'){
    idValExp="Integer.toString(id)";
    idV1='"1"';
    idV2='"2"';
  }
}
%>package ${parentPkgName}.${AutoCapProc(curModel.name,'JavaPackageName')}.${AutoCapProc(tb.name,'JavaPackageName')};

import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

import com.fasterxml.jackson.databind.ObjectMapper;
import org.junit.jupiter.api.BeforeEach;
import org.junit.jupiter.api.Test;
import org.mockito.InjectMocks;
import org.mockito.Mock;
import org.mockito.MockitoAnnotations;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.boot.test.autoconfigure.web.servlet.AutoConfigureMockMvc;
import org.springframework.boot.test.context.SpringBootTest;
import org.springframework.http.MediaType;
import org.springframework.test.web.servlet.MockMvc;
import org.springframework.test.web.servlet.setup.MockMvcBuilders;

import java.util.Arrays;
import java.util.Date;
import java.util.List;

import static org.mockito.ArgumentMatchers.any;
import static org.mockito.Mockito.when;
import static org.springframework.test.web.servlet.request.MockMvcRequestBuilders.*;
import static org.springframework.test.web.servlet.result.MockMvcResultMatchers.*;
import static org.springframework.test.web.servlet.result.MockMvcResultHandlers.print;

@SpringBootTest
@AutoConfigureMockMvc
public class ${ClsName}ControllerTest {

    protected Log logger= LogFactory.getLog(${ClsName}ControllerTest.class);

    @Autowired
    private MockMvc mockMvc;

    @Mock
    private ${ClsName}Service ${tbName}Service;

    @InjectMocks
    private ${ClsName}Controller ${tbName}Controller;

    private ObjectMapper objectMapper;

    @BeforeEach
    public void setUp() {
        MockitoAnnotations.openMocks(this);
        mockMvc = MockMvcBuilders.standaloneSetup(${tbName}Controller).build();
        objectMapper = new ObjectMapper();
    }

    public void wLogOk(String msg){
        logger.info(">>>>>>> "+msg);
    }

    public ${ClsName} createNewItem(${idTp} ${idValExp}){
      ${ClsName} res = new ${ClsName}();
      res.set${AutoCapProc(pkField,'ClassName')}(${idValExp});
      return res;
    }

    @Test
    public void testList() throws Exception {
        long startTime = System.currentTimeMillis();

        ${ClsName} ${tbName}1 = createNewItem(${idV1});
        ${ClsName} ${tbName}2 = createNewItem(${idV2});
        List<${ClsName}> ${tbName}s = Arrays.asList(${tbName}1, ${tbName}2);

        when(${tbName}Service.findAll()).thenReturn(${tbName}s);

        String url = "/ez_${AutoCapProc(tb.name,'PackageName')}/list";
        mockMvc.perform(get(url)
                .contentType(MediaType.APPLICATION_JSON))
                .andExpect(status().isOk())
                .andExpect(jsonPath("$[0].${pkField}").value("1"))
                .andExpect(jsonPath("$[1].${pkField}").value("2"))
                .andDo(print());

        long endTime = System.currentTimeMillis();
        wLogOk(url + " executed successfully in " + (endTime - startTime) + " ms");
    }

    @Test
    public void testGetById() throws Exception {
        long startTime = System.currentTimeMillis();

        ${ClsName} ${tbName} = createNewItem(${idV1});

        when(${tbName}Service.findById(1L)).thenReturn(${tbName});
                                      
        String url = "/ez_${AutoCapProc(tb.name,'PackageName')}/getById";
        mockMvc.perform(get(url)
                .param("id", "1")
                .contentType(MediaType.APPLICATION_JSON))
                .andExpect(status().isOk())
                .andExpect(jsonPath("$.${pkField}").value("1"))
                .andDo(print());

        long endTime = System.currentTimeMillis();
        wLogOk(url + " executed successfully in " + (endTime - startTime) + " ms");
    }

    @Test
    public void testCount() throws Exception {
        long startTime = System.currentTimeMillis();

        when(${tbName}Service.count()).thenReturn(10L);

        String url = "/ez_${AutoCapProc(tb.name,'PackageName')}/count";
        mockMvc.perform(get(url)
                .contentType(MediaType.APPLICATION_JSON))
                .andExpect(status().isOk())
                .andExpect(content().string("10"))
                .andDo(print());

        long endTime = System.currentTimeMillis();
        wLogOk(url + " executed successfully in " + (endTime - startTime) + " ms");
    }

    @Test
    public void testAdd() throws Exception {
        long startTime = System.currentTimeMillis();

        ${ClsName} ${tbName} = createNewItem(${idV1});

        when(${tbName}Service.add(any(${ClsName}.class))).thenReturn(${tbName});

        String url = "/ez_${AutoCapProc(tb.name,'PackageName')}/add";
        mockMvc.perform(get(url)
                .contentType(MediaType.APPLICATION_JSON)
                .content(objectMapper.writeValueAsString(${tbName})))
                .andExpect(status().isOk())
                .andExpect(jsonPath("$.${pkField}").value("1"))
                .andDo(print());

        long endTime = System.currentTimeMillis();
        wLogOk(url + " executed successfully in " + (endTime - startTime) + " ms");
    }

    @Test
    public void testUpdate() throws Exception {
        long startTime = System.currentTimeMillis();

        ${ClsName} ${tbName} = createNewItem(${idV1});

        when(${tbName}Service.update(any(${ClsName}.class))).thenReturn(${tbName});

        String url = "/ez_${AutoCapProc(tb.name,'PackageName')}/update";
        mockMvc.perform(get(url)
                .contentType(MediaType.APPLICATION_JSON)
                .content(objectMapper.writeValueAsString(${tbName})))
                .andExpect(status().isOk())
                .andExpect(jsonPath("$.${pkField}").value("1"))
                .andDo(print());

        long endTime = System.currentTimeMillis();
        wLogOk(url + " executed successfully in " + (endTime - startTime) + " ms");
    }

    @Test
    public void testDeleteById() throws Exception {
        long startTime = System.currentTimeMillis();

        String url = "/ez_${AutoCapProc(tb.name,'PackageName')}/deleteById";
        mockMvc.perform(get(url)
                .param("id", "1")
                .contentType(MediaType.APPLICATION_JSON))
                .andExpect(status().isOk())
                .andDo(print());

        long endTime = System.currentTimeMillis();
        wLogOk(url + " executed successfully in " + (endTime - startTime) + " ms");
    }

    @Test
    public void testDeleteByIds() throws Exception {
        long startTime = System.currentTimeMillis();
                                             
        String url = "/ez_${AutoCapProc(tb.name,'PackageName')}/deleteByIds";  
                
        mockMvc.perform(get(url)
                .param("ids", "1,3,25")
                .contentType(MediaType.APPLICATION_JSON))
                .andExpect(status().isOk());

        long endTime = System.currentTimeMillis();
        wLogOk(url + " executed successfully in " + (endTime - startTime) + " ms");
    }
}